<?php
/* --------------------------------------------------------------
 TranslationsLoader.php 2020-03-02
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Gambio\Admin\Layout\Smarty\TemplateTranslations;
use Smarty;

/**
 * Class TranslationsLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class TranslationsLoader implements LoaderInterface
{
    /**
     * @var TemplateTranslations
     */
    private $translations;
    
    
    /**
     * TranslationsLoader constructor.
     *
     * @param TemplateTranslations $translations
     */
    public function __construct(TemplateTranslations $translations)
    {
        $this->translations = $translations;
    }
    
    
    /**
     * Loads translations and assign it to smarty.
     *
     * @param Smarty $smarty
     */
    public function load(Smarty $smarty): void
    {
        $this->translations->addSection('general');
        $this->translations->addSection('buttons');
        $this->translations->addSection('messages');
        $this->translations->addSection('admin_labels');
        $this->translations->addSection('admin_general');
        $this->translations->addSection('admin_info_boxes');
        
        $smarty->assign('translations', json_encode($this->translations));
    }
}